
### Official documentation: 
https://brainstation.io/cybersecurity/two-factor-auth

### Factors of Authentication

An authentication factor is a category of security credential used to verify a user's identity and authorization before allowing that user to gain access to their account, send communications, or request data from a secured network, system, or application.

There are three common factors of authentication: something you are, something you know, and something you have. Let's break them down further:

-   **Something you are**. This type of 2FA includes biometric methods like fingerprint, retinal or facial scans, handwriting analysis, or voice recognition. Most modern smartphones use face recognition, laptops often use fingerprint readers and you might even be asked to enter a handprint if you buy a season pass to an amusement park. Although this type of 2FA provides the strongest authentication of any two-factor authentication method, it's not perfect. Anyone who's ever had a device with the capacity to scan faces or fingerprints has experienced the frustration of trying and failing to get their iPhone to accept their face or fingerprint knows that.
-   **Something you know**. This might be the most common factor used in two-factor authentication. Generally, this will be a password or personal identification number (PIN). Unfortunately, these authentication factors are also the ones most vulnerable to security attacks. Many people use the same passwords on account after account, and if there's a breach on even one account, that means every account is compromised.
-   **Something you have**. This type of factor is typically controlled through a device that is known to be in the possession of a rightful user (usually a smartphone). First, a user registers for an account with an email address and password, recording their phone number then. The user then logs into their account with that email address and password, at which point a one-time password is sent to the user's mobile phone number. Once the user enters that into their device, they gain access to their account and the system.