## What is TCP ?

[TCP](https://networkinterview.com/tcp/) is a connection-oriented protocol which states a connection is established and maintained until the application data at each end have finished exchange. TCP breaks application data into packets. This packet delivers to the transport layer. Layer 4 manages flow control and provide error free data transmission and handles retransmission of dropped or garbled packets and acknowledges all packets that arrive. In the OSI model, TCP covers parts of Layer 4 the transport layer and Layer 5 covers the session layer.

## **How TCP Works**

TCP’s job is to ensure that all data sent in a stream moves from client to server in a correct order and is intact. TCP uses a technique known as positive acknowledgement with retransmission, requiring the receiving end of a transmission to give a response as to what data has been received. The bytes sent can exactly match the bytes received. No data is altered or lost along the way.

Connection is established and a 3-way handshake is made. First, the source sends a SYN request packet to the server in order to start session establishment process. Then, the server sends a SYN-ACK packet to agree to the process. Lastly, the source sends an ACK packet to the target to confirm the process, after which the data can be sent.

## **Comparison of TCP and HTTP**

1. HTTP is a HyperText Transfer Protocol, whereas TCP full form is Transmission Control Protocol.
2. HTTP is utilized to access websites, while TCP is a session establishment protocol between client and server.
3. HTTP uses port 80 and TCP uses no port.
4. HTTP doesn’t need authentication, whereas, TCP uses the TCP-AO.
5. HTTP is Stateless but not session less. In contrast, TCP is a Connection-Oriented Protocol.
6. HTTP is a One-way communication system, while on the other hand, [TCP is a 3-Way Handshake](https://ipwithease.com/tcp-fin-vs-rst-packets/)(SYN, SYN-ACK, ACK).
7. In case you’re using HTTP, HTTP appears in the URL of the site, and if you’re using TCP, TCP appears in IP.
8. HTTP establishes data link communication only but TCP establishes session connection.
9. HTTP is useful for transfer of smaller documents like webpages, on the other hand, TCP is useful to setup connection for data transfer.
10. HTTP is faster in comparison to TCP, which is slower